@extends('layouts.admin')

@section('content')
<div class="roles-management">
    <div class="dashboard-header">
        <h1>Edit Permission</h1>
        <p>Update permission details</p>
    </div>

    <div class="dashboard-card">
        <div class="dashboard-card-header">
            <h3>Permission Details</h3>
        </div>
        <div class="dashboard-card-body">
            <form action="{{ route('admin.permissions.update', $permission) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="form-group">
                    <label for="name">Permission Name</label>
                    <input type="text" class="form-control" id="name" name="name" value="{{ old('name', $permission->name) }}" required>
                    @error('name')
                        <div class="error-message">{{ $message }}</div>
                    @enderror
                    <div class="form-text">Enter a unique name for this permission</div>
                </div>

                <div class="form-group mt-4">
                    <button type="submit" class="btn btn-primary">Update Permission</button>
                    <a href="{{ route('admin.permissions') }}" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection